set memory 50m
program ML_PTPrelec
args lnf rho alpha beta noise
tempvar ch mminl mmaxl pl ptl ptr ptdiff dwl
quietly {
generate double `mminl'=$ML_y1
generate double `mmaxl'=$ML_y2
generate double `pl'=$ML_y3
generate double `ptr'=$ML_y4
generate int  `ch'=$ML_y5
generate double `dwl'=(exp(-(-ln(`pl'))^ `alpha'))^ `beta'
generate double `ptl'=(`dwl'*(`mmaxl'^`rho')+(1-`dwl')*(`mminl'^`rho'))^(1/`rho')
generate double `ptdiff' = (`ptr'-`ptl')/`noise'
replace `lnf' = ln(normal(`ptdiff')) if `ch'==1
replace `lnf' = ln(normal(-`ptdiff')) if `ch'==0
}
end
insheet id qu ur mil mal p1 p2 p3 p4 p5 p6 p7 p8 mr ch using "\\WRITE THE PATH TO THE FILE HERE\Ellsberg - Dataset.csv",clear
drop qu
generate p=(p1+p2+p3+p4+p5+p6+p7+p8)/8
ml model lf ML_PTPrelec (rho: mil mal p mr ch = ur) (alpha: = ur) (beta: = ur) (noise:), cluster(id) technique(nr) maximize
